package view;

import java.awt.GridLayout;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

import control.FilterListener;

import model.Catalogo;

public class FilterExpPanel extends JPanel {

	private String[] sale = new String[] { "Tutti", "il Salone Medioevale",
			"il Salone Rinascimentale", "la Sala dell'Inquisizione",
			"la Sala delle Scienze Moderne", "la Sala delle Tecnologie moderne" };

	private JComboBox<String> box = new JComboBox<String>(sale);

	private static final long serialVersionUID = 1L;
	private Catalogo catalogo;

	public FilterExpPanel(Catalogo catalogo) {
		this.catalogo = catalogo;

		setBorder(BorderFactory.createEtchedBorder());
		setLayout(new GridLayout(1, 2));

		// JButton button = new JButton("Filtra");
		JButton export = new JButton("Esporta");

		add(this.box);
		add(export);

		FilterListener listener = new FilterListener(catalogo, box);
		box.addActionListener(listener);
		export.addActionListener(listener);

	}
}
